 ; Ŀ
 ;   Pivot - rotate text, attributes, and attdefs into the next isoplane.  
 ;   Copyright 1994 by Rocket Software.                                    
 ;   Isometrics - engineering's answer to perspective.                     
 ; 
 (DEFUN C:PIVOT (/ txt enam nent outer typ 11pi6 piovr6 halfpi nogo rota oblq)
  (setvar "cmdecho" 0)
  (command "undo" "m")
  (setq enam (car (setq nent (nentsel
                            "Select an attribute, text, a chicken, etc.: "))))
  (if enam
     (progn
         (setq outer (caar (reverse nent)))
         (setq txt (entget enam))
         (setq typ (cdr (assoc 0 txt)))))
  (setq 11pi6 (* pi (/ 11.0 6)))                       ; 11Pi/6 = 330
  (setq piovr6 (/ pi 6))                               ; Pi/6 = 30.
  (setq halfpi (/ pi 2))                               ; Pi/2 = 90
 ; Ŀ
 ;   See what it was and react accordingly.  If nothing was selected:      
 ; 
  (cond ((null typ)
         (setq nogo T)
         (write-line "\nNothing selected."))
 ; Ŀ
 ;   An entity was picked but it wasn't anything like text.                
 ; 
        ((and (/= "TEXT" typ) (/= "ATTDEF" typ) (/= "ATTRIB" typ))
         (setq nogo T)
         (write-line "\nThat was not text"))
 ; Ŀ
 ;   The rotation or obliquing groups weren't present.  (Might later on    
 ;   modify so can add them.)                                              
 ; 
        ((or (null (setq rota (assoc 50 txt)))
             (null (setq oblq (assoc 51 txt))))
         (setq nogo T)
         (write-line "\nThat was not isometric text"))
 ; Ŀ
 ;   If there was a rotation and obliquing angle group matching a          
 ;   standard iso text style then cycle it through to the next plane.      
 ;   (The order matches the order of testing in this file.)                
 ;   Rotation = Pi/6 = 30; Obliquing angle = Pi/6 = 30 (ISO30VERT)       
 ; 
        ((and (equal (cdr rota) piovr6 0.005)
              (equal (cdr oblq) piovr6 0.005))
         (setq txt (subst (cons 50 11pi6) rota txt))
         (entmod (subst (cons 51 11pi6) oblq txt)))
 ; Ŀ
 ;   Rotation = 11Pi/6 = 330; Obliquing angle =11Pi/6 = 330              
 ;   (ISO330VERT)                                                          
 ; 
        ((and (equal (cdr rota) 11pi6 0.005)
              (equal (cdr oblq) 11pi6 0.005))
         (setq txt (subst (cons 50 halfpi) rota txt))
         (entmod (subst (cons 51 piovr6) oblq txt)))
 ; Ŀ
 ;   Rotation = Pi/2 = 90; Obliquing angle = Pi/6 = 30 (ISO90LEFT)       
 ; 
        ((and (equal (cdr rota) halfpi 0.005)
              (equal (cdr oblq) piovr6 0.005))
         (setq txt (subst (cons 50 piovr6) rota txt))
         (entmod (subst (cons 51 11pi6) oblq txt)))
 ; Ŀ
 ;   Rotation = Pi/6 = 30; Obliquing angle = 11Pi/6 = 330 (ISO30HOR)     
 ; 
        ((and (equal (cdr rota) piovr6 0.005)
              (equal (cdr oblq) 11pi6 0.005))
         (setq txt (subst (cons 50 11pi6) rota txt))
         (entmod (subst (cons 51 piovr6) oblq txt)))
 ; Ŀ
 ;   Rotation = 11Pi/6 = 330; Obliquing angle = Pi/6 = 30 (ISO330HOR)    
 ; 
        ((and (equal (cdr rota) 11pi6 0.005)
              (equal (cdr oblq) piovr6 0.005))
         (setq txt (subst (cons 50 halfpi) rota txt))
         (entmod (subst (cons 51 11pi6) oblq txt)))
 ; Ŀ
 ;   Rotation = Pi/2 = 90; Obliquing angle = 11Pi/6 = 330 (ISO90RIGHT)   
 ;   or any other undefined (but with 50 and 51 lists) text.               
 ; 
        (T
         (setq txt (subst (cons 50 piovr6) rota txt))
         (entmod (subst (cons 51 piovr6) oblq txt))))
  (if (null nogo)
      (progn
           (entupd enam)
           (if (= (type outer) 'ENAME)
               (entupd outer))))
 (princ))